/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.content;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.EditHistory;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutEditorScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.content.button.LayoutVanillaButton;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.FMContextMenu;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.UIBase;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.popup.FMTextInputPopup;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.popup.FMYesNoPopup;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.KeyboardData;
import de.keksuccino.konkrete.input.KeyboardHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import org.lwjgl.glfw.GLFW;

public abstract class LayoutElement
extends AbstractGui {
    public CustomizationItemBase object;
    public LayoutEditorScreen handler;
    protected boolean hovered = false;
    protected boolean dragging = false;
    protected boolean resizing = false;
    protected int activeGrabber = -1;
    protected int lastGrabber;
    protected int startDiffX;
    protected int startDiffY;
    protected int startX;
    protected int startY;
    protected int startWidth;
    protected int startHeight;
    protected int orientationDiffX = 0;
    protected int orientationDiffY = 0;
    protected boolean stretchable = false;
    protected boolean stretchX = false;
    protected boolean stretchY = false;
    protected boolean orderable = true;
    protected boolean copyable = true;
    protected boolean delayable = true;
    protected boolean fadeable = true;
    protected List<LayoutElement> hoveredLayers = new ArrayList<LayoutElement>();
    public FMContextMenu rightclickMenu;
    protected AdvancedButton stretchXButton;
    protected AdvancedButton stretchYButton;
    protected AdvancedButton o1;
    protected AdvancedButton o2;
    protected AdvancedButton o3;
    protected AdvancedButton o4;
    protected AdvancedButton o5;
    protected AdvancedButton o6;
    protected AdvancedButton o7;
    protected AdvancedButton o8;
    protected AdvancedButton o9;
    protected static boolean isShiftPressed = false;
    private static boolean shiftListener = false;
    private final boolean destroyable;
    public final String objectId = UUID.randomUUID().toString();
    private EditHistory.Snapshot cachedSnapshot;
    private boolean moving = false;
    protected static final long hResizeCursor = GLFW.glfwCreateStandardCursor((int)221189);
    protected static final long vResizeCursor = GLFW.glfwCreateStandardCursor((int)221190);
    protected static final long normalCursor = GLFW.glfwCreateStandardCursor((int)221185);

    public LayoutElement(@Nonnull CustomizationItemBase object, boolean destroyable, @Nonnull LayoutEditorScreen handler) {
        this.handler = handler;
        this.object = object;
        this.destroyable = destroyable;
        if (!shiftListener) {
            KeyboardHandler.addKeyPressedListener((Consumer)new Consumer<KeyboardData>(){

                @Override
                public void accept(KeyboardData t) {
                    if (t.keycode == 340 || t.keycode == 344) {
                        isShiftPressed = true;
                    }
                }
            });
            KeyboardHandler.addKeyReleasedListener((Consumer)new Consumer<KeyboardData>(){

                @Override
                public void accept(KeyboardData t) {
                    if (t.keycode == 340 || t.keycode == 344) {
                        isShiftPressed = false;
                    }
                }
            });
            shiftListener = true;
        }
        this.init();
    }

    public void init() {
        this.rightclickMenu = new FMContextMenu();
        this.rightclickMenu.setAlwaysOnTop(true);
        FMContextMenu orientationMenu = new FMContextMenu();
        orientationMenu.setAutoclose(true);
        this.rightclickMenu.addChild(orientationMenu);
        this.o1 = new AdvancedButton(0, 0, 0, 16, "top-left", press -> {
            this.handler.setObjectFocused(this, false, true);
            this.setOrientation("top-left");
            orientationMenu.closeMenu();
        });
        orientationMenu.addContent(this.o1);
        this.o2 = new AdvancedButton(0, 0, 0, 16, "mid-left", press -> {
            this.handler.setObjectFocused(this, false, true);
            this.setOrientation("mid-left");
            orientationMenu.closeMenu();
        });
        orientationMenu.addContent(this.o2);
        this.o3 = new AdvancedButton(0, 0, 0, 16, "bottom-left", press -> {
            this.handler.setObjectFocused(this, false, true);
            this.setOrientation("bottom-left");
            orientationMenu.closeMenu();
        });
        orientationMenu.addContent(this.o3);
        this.o4 = new AdvancedButton(0, 0, 0, 16, "top-centered", press -> {
            this.handler.setObjectFocused(this, false, true);
            this.setOrientation("top-centered");
            orientationMenu.closeMenu();
        });
        orientationMenu.addContent(this.o4);
        this.o5 = new AdvancedButton(0, 0, 0, 16, "mid-centered", press -> {
            this.handler.setObjectFocused(this, false, true);
            this.setOrientation("mid-centered");
            orientationMenu.closeMenu();
        });
        orientationMenu.addContent(this.o5);
        this.o6 = new AdvancedButton(0, 0, 0, 16, "bottom-centered", press -> {
            this.handler.setObjectFocused(this, false, true);
            this.setOrientation("bottom-centered");
            orientationMenu.closeMenu();
        });
        orientationMenu.addContent(this.o6);
        this.o7 = new AdvancedButton(0, 0, 0, 16, "top-right", press -> {
            this.handler.setObjectFocused(this, false, true);
            this.setOrientation("top-right");
            orientationMenu.closeMenu();
        });
        orientationMenu.addContent(this.o7);
        this.o8 = new AdvancedButton(0, 0, 0, 16, "mid-right", press -> {
            this.handler.setObjectFocused(this, false, true);
            this.setOrientation("mid-right");
            orientationMenu.closeMenu();
        });
        orientationMenu.addContent(this.o8);
        this.o9 = new AdvancedButton(0, 0, 0, 16, "bottom-right", press -> {
            this.handler.setObjectFocused(this, false, true);
            this.setOrientation("bottom-right");
            orientationMenu.closeMenu();
        });
        orientationMenu.addContent(this.o9);
        AdvancedButton orientationButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.creator.items.setorientation", (String[])new String[0]), true, press -> {
            orientationMenu.setParentButton((AdvancedButton)press);
            orientationMenu.openMenuAt(0, press.field_230691_m_);
        });
        orientationButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.creator.items.orientation.btndesc", (String[])new String[0]), (String)"%n%"));
        this.rightclickMenu.addContent(orientationButton);
        FMContextMenu layersMenu = new FMContextMenu();
        layersMenu.setAutoclose(true);
        this.rightclickMenu.addChild(layersMenu);
        AdvancedButton layersButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.creator.items.chooselayer", (String[])new String[0]), true, press -> {
            layersMenu.getContent().clear();
            for (LayoutElement o : this.hoveredLayers) {
                String label = o.object.value;
                if (label == null) {
                    label = "Object";
                } else if (Minecraft.func_71410_x().field_71466_p.func_78256_a(label) > 200) {
                    label = Minecraft.func_71410_x().field_71466_p.func_238412_a_(label, 200) + "..";
                }
                AdvancedButton btn = new AdvancedButton(0, 0, 0, 0, label, press2 -> {
                    this.handler.clearFocusedObjects();
                    this.handler.setObjectFocused(o, true, true);
                });
                layersMenu.addContent(btn);
            }
            layersMenu.setParentButton((AdvancedButton)press);
            layersMenu.openMenuAt(0, press.field_230691_m_);
        });
        this.rightclickMenu.addContent(layersButton);
        FMContextMenu stretchMenu = new FMContextMenu();
        stretchMenu.setAutoclose(true);
        this.rightclickMenu.addChild(stretchMenu);
        this.stretchXButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.creator.object.stretch.x", (String[])new String[0]), true, press -> {
            if (this.stretchX) {
                this.setStretchedX(false, true);
            } else {
                this.setStretchedX(true, true);
            }
        });
        stretchMenu.addContent(this.stretchXButton);
        this.stretchYButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.creator.object.stretch.y", (String[])new String[0]), true, press -> {
            if (this.stretchY) {
                this.setStretchedY(false, true);
            } else {
                this.setStretchedY(true, true);
            }
        });
        stretchMenu.addContent(this.stretchYButton);
        AdvancedButton stretchButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.creator.object.stretch", (String[])new String[0]), true, press -> {
            stretchMenu.setParentButton((AdvancedButton)press);
            stretchMenu.openMenuAt(0, press.field_230691_m_);
        });
        if (this.stretchable) {
            this.rightclickMenu.addContent(stretchButton);
        }
        AdvancedButton moveUpButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.creator.object.moveup", (String[])new String[0]), press -> {
            LayoutElement o = this.handler.moveUp(this);
            if (o != null) {
                ((AdvancedButton)press).setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.creator.object.moveup.desc", (String[])new String[]{Locals.localize((String)"helper.creator.object.moveup.desc.subtext", (String[])new String[]{o.object.value})}), (String)"%n%"));
            }
        });
        moveUpButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.creator.object.moveup.desc", (String[])new String[]{""}), (String)"%n%"));
        if (this.orderable) {
            this.rightclickMenu.addContent(moveUpButton);
        }
        AdvancedButton moveDownButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.creator.object.movedown", (String[])new String[0]), press -> {
            LayoutElement o = this.handler.moveDown(this);
            if (o != null) {
                if (o instanceof LayoutVanillaButton) {
                    ((AdvancedButton)press).setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.creator.object.movedown.desc", (String[])new String[]{Locals.localize((String)"helper.creator.object.movedown.desc.subtext.vanillabutton", (String[])new String[0])}), (String)"%n%"));
                } else {
                    ((AdvancedButton)press).setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.creator.object.movedown.desc", (String[])new String[]{Locals.localize((String)"helper.creator.object.movedown.desc.subtext", (String[])new String[]{o.object.value})}), (String)"%n%"));
                }
            }
        });
        moveDownButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.creator.object.movedown.desc", (String[])new String[]{""}), (String)"%n%"));
        if (this.orderable) {
            this.rightclickMenu.addContent(moveDownButton);
        }
        AdvancedButton copyButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.editor.ui.edit.copy", (String[])new String[0]), press -> this.handler.copySelectedElements());
        if (this.copyable) {
            this.rightclickMenu.addContent(copyButton);
        }
        AdvancedButton destroyButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.creator.items.delete", (String[])new String[0]), true, press -> this.destroyObject());
        if (this.destroyable) {
            this.rightclickMenu.addContent(destroyButton);
        }
        FMContextMenu delayMenu = new FMContextMenu();
        delayMenu.setAutoclose(true);
        this.rightclickMenu.addChild(delayMenu);
        String tdLabel = Locals.localize((String)"helper.creator.items.delay.off", (String[])new String[0]);
        if (this.object.delayAppearance) {
            tdLabel = Locals.localize((String)"helper.creator.items.delay.everytime", (String[])new String[0]);
        }
        if (this.object.delayAppearance && !this.object.delayAppearanceEverytime) {
            tdLabel = Locals.localize((String)"helper.creator.items.delay.firsttime", (String[])new String[0]);
        }
        AdvancedButton toggleDelayButton = new AdvancedButton(0, 0, 0, 0, tdLabel, true, press -> {
            this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
            if (!this.object.delayAppearance) {
                ((AdvancedButton)press).setMessage(Locals.localize((String)"helper.creator.items.delay.firsttime", (String[])new String[0]));
                this.object.delayAppearance = true;
                this.object.delayAppearanceEverytime = false;
            } else if (this.object.delayAppearance && !this.object.delayAppearanceEverytime) {
                ((AdvancedButton)press).setMessage(Locals.localize((String)"helper.creator.items.delay.everytime", (String[])new String[0]));
                this.object.delayAppearance = true;
                this.object.delayAppearanceEverytime = true;
            } else if (this.object.delayAppearance && this.object.delayAppearanceEverytime) {
                ((AdvancedButton)press).setMessage(Locals.localize((String)"helper.creator.items.delay.off", (String[])new String[0]));
                this.object.delayAppearance = false;
                this.object.delayAppearanceEverytime = false;
            }
        });
        delayMenu.addContent(toggleDelayButton);
        AdvancedButton delaySecondsButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.creator.items.delay.seconds", (String[])new String[0]), true, press -> {
            FMTextInputPopup p = new FMTextInputPopup(new Color(0, 0, 0, 0), "\u00a7f" + Locals.localize((String)"helper.creator.items.delay.seconds", (String[])new String[0]), CharacterFilter.getDoubleCharacterFiler(), 240, call -> {
                if (call != null) {
                    if (!call.equals("" + this.object.delayAppearanceSec)) {
                        this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
                    }
                    if (call.replace(" ", "").equals("")) {
                        this.object.delayAppearanceSec = 1.0f;
                    } else if (MathUtils.isFloat((String)call)) {
                        this.object.delayAppearanceSec = Float.parseFloat(call);
                    }
                }
            });
            p.setText("" + this.object.delayAppearanceSec);
            PopupHandler.displayPopup((Popup)p);
        }){

            public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
                this.field_230693_o_ = LayoutElement.this.object.delayAppearance;
                super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            }
        };
        delayMenu.addContent(delaySecondsButton);
        delayMenu.addSeparator();
        String fiLabel = Locals.localize((String)"helper.creator.items.delay.fadein.off", (String[])new String[0]);
        if (this.object.delayAppearance && this.object.fadeIn) {
            fiLabel = Locals.localize((String)"helper.creator.items.delay.fadein.on", (String[])new String[0]);
        }
        AdvancedButton toggleFadeButton = new AdvancedButton(0, 0, 0, 0, fiLabel, true, press -> {
            if (!this.object.fadeIn) {
                ((AdvancedButton)press).setMessage(Locals.localize((String)"helper.creator.items.delay.fadein.on", (String[])new String[0]));
                this.object.fadeIn = true;
            } else {
                ((AdvancedButton)press).setMessage(Locals.localize((String)"helper.creator.items.delay.fadein.off", (String[])new String[0]));
                this.object.fadeIn = false;
            }
        }){

            public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
                this.field_230693_o_ = LayoutElement.this.object.delayAppearance;
                super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            }
        };
        if (this.fadeable) {
            delayMenu.addContent(toggleFadeButton);
        }
        AdvancedButton fadeSpeedButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.creator.items.delay.fadein.speed", (String[])new String[0]), true, press -> {
            FMTextInputPopup p = new FMTextInputPopup(new Color(0, 0, 0, 0), "\u00a7f" + Locals.localize((String)"helper.creator.items.delay.fadein.speed", (String[])new String[0]), CharacterFilter.getDoubleCharacterFiler(), 240, call -> {
                if (call != null) {
                    if (!call.equals("" + this.object.fadeInSpeed)) {
                        this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
                    }
                    if (call.replace(" ", "").equals("")) {
                        this.object.fadeInSpeed = 1.0f;
                    } else if (MathUtils.isFloat((String)call)) {
                        this.object.fadeInSpeed = Float.parseFloat(call);
                    }
                }
            });
            p.setText("" + this.object.fadeInSpeed);
            PopupHandler.displayPopup((Popup)p);
        }){

            public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
                this.field_230693_o_ = LayoutElement.this.object.delayAppearance;
                super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            }
        };
        if (this.fadeable) {
            delayMenu.addContent(fadeSpeedButton);
        }
        AdvancedButton delayButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.creator.items.delay", (String[])new String[0]), true, press -> {
            delayMenu.setParentButton((AdvancedButton)press);
            delayMenu.openMenuAt(0, press.field_230691_m_);
        });
        if (this.delayable) {
            this.rightclickMenu.addContent(delayButton);
        }
        this.rightclickMenu.addSeparator();
    }

    protected void setOrientation(String pos) {
        this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
        if (pos.equals("mid-left")) {
            this.object.orientation = pos;
            this.object.posX = 0;
            this.object.posY = -(this.object.height / 2);
        } else if (pos.equals("bottom-left")) {
            this.object.orientation = pos;
            this.object.posX = 0;
            this.object.posY = -this.object.height;
        } else if (pos.equals("top-centered")) {
            this.object.orientation = pos;
            this.object.posX = -(this.object.width / 2);
            this.object.posY = 0;
        } else if (pos.equals("mid-centered")) {
            this.object.orientation = pos;
            this.object.posX = -(this.object.width / 2);
            this.object.posY = -(this.object.height / 2);
        } else if (pos.equals("bottom-centered")) {
            this.object.orientation = pos;
            this.object.posX = -(this.object.width / 2);
            this.object.posY = -this.object.height;
        } else if (pos.equals("top-right")) {
            this.object.orientation = pos;
            this.object.posX = -this.object.width;
            this.object.posY = 0;
        } else if (pos.equals("mid-right")) {
            this.object.orientation = pos;
            this.object.posX = -this.object.width;
            this.object.posY = -(this.object.height / 2);
        } else if (pos.equals("bottom-right")) {
            this.object.orientation = pos;
            this.object.posX = -this.object.width;
            this.object.posY = -this.object.height;
        } else {
            this.object.orientation = pos;
            this.object.posX = 0;
            this.object.posY = 0;
        }
    }

    protected int orientationMouseX(int mouseX) {
        if (this.object.orientation.endsWith("-centered")) {
            return mouseX - this.handler.field_230708_k_ / 2;
        }
        if (this.object.orientation.endsWith("-right")) {
            return mouseX - this.handler.field_230708_k_;
        }
        return mouseX;
    }

    protected int orientationMouseY(int mouseY) {
        if (this.object.orientation.startsWith("mid-")) {
            return mouseY - this.handler.field_230709_l_ / 2;
        }
        if (this.object.orientation.startsWith("bottom-")) {
            return mouseY - this.handler.field_230709_l_;
        }
        return mouseY;
    }

    public void setStretchedX(boolean b, boolean saveSnapshot) {
        if (this.isOrientationSupportedByStretchAction(b, this.stretchY)) {
            if (saveSnapshot) {
                this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
            }
            this.stretchX = b;
            String stretchXLabel = Locals.localize((String)"helper.creator.object.stretch.x", (String[])new String[0]);
            if (this.stretchX) {
                stretchXLabel = "\u00a7a" + stretchXLabel;
            }
            if (this.stretchXButton != null) {
                this.stretchXButton.setMessage(stretchXLabel);
            }
        }
    }

    public void setStretchedY(boolean b, boolean saveSnapshot) {
        if (this.isOrientationSupportedByStretchAction(this.stretchX, b)) {
            if (saveSnapshot) {
                this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
            }
            this.stretchY = b;
            String stretchYLabel = Locals.localize((String)"helper.creator.object.stretch.y", (String[])new String[0]);
            if (this.stretchY) {
                stretchYLabel = "\u00a7a" + stretchYLabel;
            }
            if (this.stretchYButton != null) {
                this.stretchYButton.setMessage(stretchYLabel);
            }
        }
    }

    private boolean isOrientationSupportedByStretchAction(boolean stX, boolean stY) {
        try {
            if (!(!stX || stY || this.object.orientation.equals("top-left") || this.object.orientation.equals("mid-left") || this.object.orientation.equals("bottom-left"))) {
                LayoutEditorScreen.displayNotification(Locals.localize((String)"helper.creator.object.stretch.unsupportedorientation", (String[])new String[]{"top-left, mid-left, bottom-left"}));
                return false;
            }
            if (!(!stY || stX || this.object.orientation.equals("top-left") || this.object.orientation.equals("top-centered") || this.object.orientation.equals("top-right"))) {
                LayoutEditorScreen.displayNotification(Locals.localize((String)"helper.creator.object.stretch.unsupportedorientation", (String[])new String[]{"top-left, top-centered, top-right"}));
                return false;
            }
            if (stX && stY && !this.object.orientation.equals("top-left")) {
                LayoutEditorScreen.displayNotification(Locals.localize((String)"helper.creator.object.stretch.unsupportedorientation", (String[])new String[]{"top-left"}));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void handleStretch() {
        try {
            if (this.stretchX) {
                this.object.posX = 0;
                this.object.width = Minecraft.func_71410_x().field_71462_r.field_230708_k_;
            }
            if (this.stretchY) {
                this.object.posY = 0;
                this.object.height = Minecraft.func_71410_x().field_71462_r.field_230709_l_;
            }
            if (this.stretchX && !this.stretchY) {
                this.o1.field_230693_o_ = true;
                this.o2.field_230693_o_ = true;
                this.o3.field_230693_o_ = true;
                this.o4.field_230693_o_ = false;
                this.o5.field_230693_o_ = false;
                this.o6.field_230693_o_ = false;
                this.o7.field_230693_o_ = false;
                this.o8.field_230693_o_ = false;
                this.o9.field_230693_o_ = false;
            }
            if (this.stretchY && !this.stretchX) {
                this.o1.field_230693_o_ = true;
                this.o2.field_230693_o_ = false;
                this.o3.field_230693_o_ = false;
                this.o4.field_230693_o_ = true;
                this.o5.field_230693_o_ = false;
                this.o6.field_230693_o_ = false;
                this.o7.field_230693_o_ = true;
                this.o8.field_230693_o_ = false;
                this.o9.field_230693_o_ = false;
            }
            if (this.stretchX && this.stretchY) {
                this.o1.field_230693_o_ = true;
                this.o2.field_230693_o_ = false;
                this.o3.field_230693_o_ = false;
                this.o4.field_230693_o_ = false;
                this.o5.field_230693_o_ = false;
                this.o6.field_230693_o_ = false;
                this.o7.field_230693_o_ = false;
                this.o8.field_230693_o_ = false;
                this.o9.field_230693_o_ = false;
            }
            if (!this.stretchX && !this.stretchY) {
                this.o1.field_230693_o_ = true;
                this.o2.field_230693_o_ = true;
                this.o3.field_230693_o_ = true;
                this.o4.field_230693_o_ = true;
                this.o5.field_230693_o_ = true;
                this.o6.field_230693_o_ = true;
                this.o7.field_230693_o_ = true;
                this.o8.field_230693_o_ = true;
                this.o9.field_230693_o_ = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void render(MatrixStack matrix, int mouseX, int mouseY) {
        this.updateHovered(mouseX, mouseY);
        try {
            this.object.render(matrix, this.handler);
            this.handleStretch();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.handler.isFocused(this)) {
            this.renderBorder(matrix, mouseX, mouseY);
        } else if (!(this.handler.getTopHoverObject() != this || this.handler.isObjectFocused() && (this.handler.isFocusedHovered() || this.handler.isFocusedDragged() || this.handler.isFocusedGettingResized() || this.handler.isFocusedGrabberPressed()))) {
            this.renderHighlightBorder(matrix);
        }
        if (this.activeGrabber == -1 && (!MouseInput.isLeftMouseDown() || PopupHandler.isPopupActive())) {
            GLFW.glfwSetCursor((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (long)normalCursor);
        }
        if (this.isLeftClicked() && !this.resizing && !this.isGrabberPressed()) {
            this.dragging = true;
        } else if (!MouseInput.isLeftMouseDown()) {
            this.dragging = false;
        }
        if ((this.isGrabberPressed() || this.resizing) && !this.isDragged() && this.handler.isFocused(this) && this.handler.getFocusedObjects().size() == 1) {
            if (!this.resizing) {
                this.cachedSnapshot = this.handler.history.createSnapshot();
                this.lastGrabber = this.getActiveResizeGrabber();
            }
            this.resizing = true;
            this.handleResize(this.orientationMouseX(mouseX), this.orientationMouseY(mouseY));
        }
        if (this.isDragged() && this.handler.isFocused(this) && this.handler.getFocusedObjects().size() == 1) {
            if (!this.moving) {
                this.cachedSnapshot = this.handler.history.createSnapshot();
            }
            this.moving = true;
            if (mouseX >= 5 && mouseX <= this.handler.field_230708_k_ - 5 && !this.stretchX) {
                this.object.posX = this.orientationMouseX(mouseX) - this.startDiffX;
            }
            if (mouseY >= 5 && mouseY <= this.handler.field_230709_l_ - 5 && !this.stretchY) {
                this.object.posY = this.orientationMouseY(mouseY) - this.startDiffY;
            }
        }
        if (!this.isDragged()) {
            this.startDiffX = this.orientationMouseX(mouseX) - this.object.posX;
            this.startDiffY = this.orientationMouseY(mouseY) - this.object.posY;
            if ((this.startX != this.object.posX || this.startY != this.object.posY) && this.moving && this.cachedSnapshot != null) {
                this.handler.history.saveSnapshot(this.cachedSnapshot);
            }
            this.moving = false;
        }
        if (!MouseInput.isLeftMouseDown()) {
            if ((this.startWidth != this.object.width || this.startHeight != this.object.height) && this.resizing && this.cachedSnapshot != null) {
                this.handler.history.saveSnapshot(this.cachedSnapshot);
            }
            this.startX = this.object.posX;
            this.startY = this.object.posY;
            this.startWidth = this.object.width;
            this.startHeight = this.object.height;
            this.resizing = false;
        }
        if (this.rightclickMenu != null) {
            if (this.isRightClicked() && this.handler.isFocused(this) && this.handler.getFocusedObjects().size() == 1) {
                UIBase.openScaledContextMenuAtMouse(this.rightclickMenu);
                this.hoveredLayers.clear();
                for (LayoutElement o : this.handler.getContent()) {
                    if (!o.isHovered()) continue;
                    this.hoveredLayers.add(o);
                }
            }
            if (MouseInput.isLeftMouseDown() && !this.rightclickMenu.isHovered()) {
                this.rightclickMenu.closeMenu();
            }
            if (MouseInput.isRightMouseDown() && !this.isHovered() && !this.rightclickMenu.isHovered()) {
                this.rightclickMenu.closeMenu();
            }
            if (this.rightclickMenu.isOpen()) {
                this.handler.setFocusChangeBlocked(this.objectId, true);
            } else {
                this.handler.setFocusChangeBlocked(this.objectId, false);
            }
        }
    }

    protected void renderBorder(MatrixStack matrix, int mouseX, int mouseY) {
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)this.object.getPosX(this.handler), (int)this.object.getPosY(this.handler), (int)(this.object.getPosX(this.handler) + this.object.width), (int)(this.object.getPosY(this.handler) + 1), (int)Color.BLUE.getRGB());
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)this.object.getPosX(this.handler), (int)(this.object.getPosY(this.handler) + this.object.height - 1), (int)(this.object.getPosX(this.handler) + this.object.width), (int)(this.object.getPosY(this.handler) + this.object.height), (int)Color.BLUE.getRGB());
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)this.object.getPosX(this.handler), (int)this.object.getPosY(this.handler), (int)(this.object.getPosX(this.handler) + 1), (int)(this.object.getPosY(this.handler) + this.object.height), (int)Color.BLUE.getRGB());
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)(this.object.getPosX(this.handler) + this.object.width - 1), (int)this.object.getPosY(this.handler), (int)(this.object.getPosX(this.handler) + this.object.width), (int)(this.object.getPosY(this.handler) + this.object.height), (int)Color.BLUE.getRGB());
        int w = 4;
        int h = 4;
        int yHorizontal = this.object.getPosY(this.handler) + this.object.height / 2 - h / 2;
        int xHorizontalLeft = this.object.getPosX(this.handler) - w / 2;
        int xHorizontalRight = this.object.getPosX(this.handler) + this.object.width - w / 2;
        int xVertical = this.object.getPosX(this.handler) + this.object.width / 2 - w / 2;
        int yVerticalTop = this.object.getPosY(this.handler) - h / 2;
        int yVerticalBottom = this.object.getPosY(this.handler) + this.object.height - h / 2;
        if (!this.stretchX) {
            AbstractGui.func_238467_a_((MatrixStack)matrix, (int)xHorizontalLeft, (int)yHorizontal, (int)(xHorizontalLeft + w), (int)(yHorizontal + h), (int)Color.BLUE.getRGB());
            AbstractGui.func_238467_a_((MatrixStack)matrix, (int)xHorizontalRight, (int)yHorizontal, (int)(xHorizontalRight + w), (int)(yHorizontal + h), (int)Color.BLUE.getRGB());
        }
        if (!this.stretchY) {
            AbstractGui.func_238467_a_((MatrixStack)matrix, (int)xVertical, (int)yVerticalTop, (int)(xVertical + w), (int)(yVerticalTop + h), (int)Color.BLUE.getRGB());
            AbstractGui.func_238467_a_((MatrixStack)matrix, (int)xVertical, (int)yVerticalBottom, (int)(xVertical + w), (int)(yVerticalBottom + h), (int)Color.BLUE.getRGB());
        }
        if (mouseX >= xHorizontalLeft && mouseX <= xHorizontalLeft + w && mouseY >= yHorizontal && mouseY <= yHorizontal + h) {
            if (!this.stretchX) {
                GLFW.glfwSetCursor((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (long)hResizeCursor);
                this.activeGrabber = 0;
            } else {
                this.activeGrabber = -1;
            }
        } else if (mouseX >= xHorizontalRight && mouseX <= xHorizontalRight + w && mouseY >= yHorizontal && mouseY <= yHorizontal + h) {
            if (!this.stretchX) {
                GLFW.glfwSetCursor((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (long)hResizeCursor);
                this.activeGrabber = 1;
            } else {
                this.activeGrabber = -1;
            }
        } else if (mouseX >= xVertical && mouseX <= xVertical + w && mouseY >= yVerticalTop && mouseY <= yVerticalTop + h) {
            if (!this.stretchY) {
                GLFW.glfwSetCursor((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (long)vResizeCursor);
                this.activeGrabber = 2;
            } else {
                this.activeGrabber = -1;
            }
        } else if (mouseX >= xVertical && mouseX <= xVertical + w && mouseY >= yVerticalBottom && mouseY <= yVerticalBottom + h) {
            if (!this.stretchY) {
                GLFW.glfwSetCursor((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (long)vResizeCursor);
                this.activeGrabber = 3;
            } else {
                this.activeGrabber = -1;
            }
        } else {
            this.activeGrabber = -1;
        }
        RenderUtils.setScale((MatrixStack)matrix, (float)0.5f);
        AbstractGui.func_238476_c_((MatrixStack)matrix, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)(Locals.localize((String)"helper.creator.items.border.orientation", (String[])new String[0]) + ": " + this.object.orientation), (int)(this.object.getPosX(this.handler) * 2), (int)(this.object.getPosY(this.handler) * 2 - 26), (int)Color.WHITE.getRGB());
        AbstractGui.func_238476_c_((MatrixStack)matrix, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)(Locals.localize((String)"helper.creator.items.border.posx", (String[])new String[0]) + ": " + this.object.getPosX(this.handler)), (int)(this.object.getPosX(this.handler) * 2), (int)(this.object.getPosY(this.handler) * 2 - 17), (int)Color.WHITE.getRGB());
        AbstractGui.func_238476_c_((MatrixStack)matrix, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)(Locals.localize((String)"helper.creator.items.border.width", (String[])new String[0]) + ": " + this.object.width), (int)(this.object.getPosX(this.handler) * 2), (int)(this.object.getPosY(this.handler) * 2 - 8), (int)Color.WHITE.getRGB());
        AbstractGui.func_238476_c_((MatrixStack)matrix, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)(Locals.localize((String)"helper.creator.items.border.posy", (String[])new String[0]) + ": " + this.object.getPosY(this.handler)), (int)((this.object.getPosX(this.handler) + this.object.width) * 2 + 3), (int)((this.object.getPosY(this.handler) + this.object.height) * 2 - 14), (int)Color.WHITE.getRGB());
        AbstractGui.func_238476_c_((MatrixStack)matrix, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)(Locals.localize((String)"helper.creator.items.border.height", (String[])new String[0]) + ": " + this.object.height), (int)((this.object.getPosX(this.handler) + this.object.width) * 2 + 3), (int)((this.object.getPosY(this.handler) + this.object.height) * 2 - 5), (int)Color.WHITE.getRGB());
        RenderUtils.postScale((MatrixStack)matrix);
    }

    protected void renderHighlightBorder(MatrixStack matrix) {
        Color c = new Color(0, 200, 255, 255);
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)this.object.getPosX(this.handler), (int)this.object.getPosY(this.handler), (int)(this.object.getPosX(this.handler) + this.object.width), (int)(this.object.getPosY(this.handler) + 1), (int)c.getRGB());
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)this.object.getPosX(this.handler), (int)(this.object.getPosY(this.handler) + this.object.height - 1), (int)(this.object.getPosX(this.handler) + this.object.width), (int)(this.object.getPosY(this.handler) + this.object.height), (int)c.getRGB());
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)this.object.getPosX(this.handler), (int)this.object.getPosY(this.handler), (int)(this.object.getPosX(this.handler) + 1), (int)(this.object.getPosY(this.handler) + this.object.height), (int)c.getRGB());
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)(this.object.getPosX(this.handler) + this.object.width - 1), (int)this.object.getPosY(this.handler), (int)(this.object.getPosX(this.handler) + this.object.width), (int)(this.object.getPosY(this.handler) + this.object.height), (int)c.getRGB());
    }

    public int getActiveResizeGrabber() {
        return this.activeGrabber;
    }

    public boolean isGrabberPressed() {
        return this.getActiveResizeGrabber() != -1 && MouseInput.isLeftMouseDown();
    }

    protected int getAspectWidth(int startW, int startH, int height) {
        double ratio = (double)startW / (double)startH;
        return (int)((double)height * ratio);
    }

    protected int getAspectHeight(int startW, int startH, int width) {
        double ratio = (double)startW / (double)startH;
        return (int)((double)width / ratio);
    }

    protected void handleResize(int mouseX, int mouseY) {
        int g = this.lastGrabber;
        int diffX = mouseX > this.startX ? Math.abs(mouseX - this.startX) : Math.negateExact(this.startX - mouseX);
        int diffY = mouseY > this.startY ? Math.abs(mouseY - this.startY) : Math.negateExact(this.startY - mouseY);
        if (!this.stretchX) {
            int h;
            int w;
            if (g == 0 && (w = this.startWidth + this.getOpponentInt(diffX)) >= 5) {
                this.object.posX = this.startX + diffX;
                this.object.width = w;
                if (isShiftPressed && (h = this.getAspectHeight(this.startWidth, this.startHeight, w)) >= 5) {
                    this.object.height = h;
                }
            }
            if (g == 1 && (w = this.object.width + (diffX - this.object.width)) >= 5) {
                this.object.width = w;
                if (isShiftPressed && (h = this.getAspectHeight(this.startWidth, this.startHeight, w)) >= 5) {
                    this.object.height = h;
                }
            }
        }
        if (!this.stretchY) {
            int w;
            int h;
            if (g == 2 && (h = this.startHeight + this.getOpponentInt(diffY)) >= 5) {
                this.object.posY = this.startY + diffY;
                this.object.height = h;
                if (isShiftPressed && (w = this.getAspectWidth(this.startWidth, this.startHeight, h)) >= 5) {
                    this.object.width = w;
                }
            }
            if (g == 3 && (h = this.object.height + (diffY - this.object.height)) >= 5) {
                this.object.height = h;
                if (isShiftPressed && (w = this.getAspectWidth(this.startWidth, this.startHeight, h)) >= 5) {
                    this.object.width = w;
                }
            }
        }
    }

    private int getOpponentInt(int i) {
        if (Math.abs(i) == i) {
            return Math.negateExact(i);
        }
        return Math.abs(i);
    }

    protected void updateHovered(int mouseX, int mouseY) {
        this.hovered = mouseX >= this.object.getPosX(this.handler) && mouseX <= this.object.getPosX(this.handler) + this.object.width && mouseY >= this.object.getPosY(this.handler) && mouseY <= this.object.getPosY(this.handler) + this.object.height;
    }

    public boolean isDragged() {
        return this.dragging;
    }

    public boolean isGettingResized() {
        return this.resizing;
    }

    public boolean isLeftClicked() {
        return this.isHovered() && MouseInput.isLeftMouseDown();
    }

    public boolean isRightClicked() {
        return this.isHovered() && MouseInput.isRightMouseDown();
    }

    public boolean isHovered() {
        return this.hovered;
    }

    public void setX(int x) {
        this.object.posX = x;
    }

    public void setY(int y) {
        this.object.posY = y;
    }

    public int getX() {
        return this.object.getPosX(this.handler);
    }

    public int getY() {
        return this.object.getPosY(this.handler);
    }

    public void setWidth(int width) {
        this.object.width = width;
    }

    public void setHeight(int height) {
        this.object.height = height;
    }

    public int getWidth() {
        return this.object.width;
    }

    public int getHeight() {
        return this.object.height;
    }

    public boolean isDestroyable() {
        return this.destroyable;
    }

    public boolean isStretchable() {
        return this.stretchable;
    }

    public void destroyObject() {
        if (!this.destroyable) {
            return;
        }
        if (((Boolean)FancyMenu.config.getOrDefault("editordeleteconfirmation", (Object)true)).booleanValue()) {
            PopupHandler.displayPopup((Popup)new FMYesNoPopup(300, new Color(0, 0, 0, 0), 240, call -> {
                if (call.booleanValue()) {
                    this.handler.deleteContentQueue.add(this);
                }
            }, "\u00a7c\u00a7l" + Locals.localize((String)"helper.creator.messages.sure", (String[])new String[0]), "", Locals.localize((String)"helper.creator.deleteobject", (String[])new String[0]), "", "", "", "", ""));
        } else {
            this.handler.deleteContentQueue.add(this);
        }
    }

    public void resetObjectStates() {
        this.hovered = false;
        this.dragging = false;
        this.resizing = false;
        this.activeGrabber = -1;
        if (this.rightclickMenu != null) {
            this.rightclickMenu.closeMenu();
        }
        this.handler.setFocusChangeBlocked(this.objectId, false);
        this.handler.setObjectFocused(this, false, true);
    }

    public abstract List<PropertiesSection> getProperties();
}

